# Name of the task (must match the one in the install script)
$taskName = "Broughton Software LabHQ Results Uploader"

function Exit-WithPrompt {
    Write-Host "Press Enter to exit..."
    [void][System.Console]::ReadLine()
    exit 1
}

# Relaunch script with elevation if not run as Administrator
if (-not ([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()
    ).IsInRole([Security.Principal.WindowsBuiltInRole]::Administrator)) {

    Write-Host "WARNING: Not running as administrator. Requesting elevation..."

    $psArgs = "-NoExit -NoProfile -ExecutionPolicy Bypass -File `"$PSCommandPath`""
    Start-Process -FilePath "pwsh.exe" -ArgumentList $psArgs -Verb RunAs
    exit
}

$task = Get-ScheduledTask -TaskName $taskName -ErrorAction SilentlyContinue

if ($null -ne $task) {
    try {
        Unregister-ScheduledTask -TaskName $taskName -Confirm:$false
        Write-Output "INFO: Task '$taskName' successfully removed."
    } catch {
        Write-Error "ERROR: Failed to remove task '$taskName': $_"
        Exit-WithPrompt
    }
} else {
    Write-Output "INFO: Task '$taskName' does not exist. Nothing to remove."
}
